package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.BillingHead;
import com.xforceplus.ultraman.app.jcunilever.service.IBillingHeadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-14
 */
@RestController
public class BillingHeadController {

  @Autowired
  private IBillingHeadService billingHeadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingHead ${table.comment}
   * @return
   */
  @GetMapping("/billingheads" )
  public XfR getBillingHeads(XfPage page, BillingHead billingHead) {
    return XfR.ok(billingHeadServiceImpl.page(page, Wrappers.query(billingHead)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billingheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingHeadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billingHead ${table.comment}
   * @return XfR
   */
  @PostMapping("/billingheads")
  public XfR save(@RequestBody BillingHead billingHead) {
     return XfR.ok(billingHeadServiceImpl.save(billingHead));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billingHead ${table.comment}
   * @return XfR
   */
  @PutMapping("/billingheads/{id}")
  public XfR putUpdate(@RequestBody BillingHead billingHead,@PathVariable Long id) {
      billingHead.setId(id);
      return XfR.ok(billingHeadServiceImpl.updateById(billingHead));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billingHead ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billingheads/{id}")
  public XfR patchUpdate(@RequestBody BillingHead billingHead,@PathVariable Long id) {
      BillingHead upbillingHead = billingHeadServiceImpl.getById(id);
      if(upbillingHead != null){
        upbillingHead = ObjectCopyUtils.copyProperties(billingHead,upbillingHead,true);
      }
      return XfR.ok(billingHeadServiceImpl.updateById(upbillingHead));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billingheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingHeadServiceImpl.removeById(id));
  }

  @PostMapping("/billingheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_head");
     params.put("request", condition);

     return XfR.ok(billingHeadServiceImpl.querys(params));
  }

}
