package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.BillingDiscountDetails;
import com.xforceplus.ultraman.app.jcunilever.service.IBillingDiscountDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class BillingDiscountDetailsController {

  @Autowired
  private IBillingDiscountDetailsService billingDiscountDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingDiscountDetails ${table.comment}
   * @return
   */
  @GetMapping("/billingdiscountdetailss" )
  public XfR getBillingDiscountDetailss(XfPage page, BillingDiscountDetails billingDiscountDetails) {
    return XfR.ok(billingDiscountDetailsServiceImpl.page(page, Wrappers.query(billingDiscountDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billingdiscountdetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingDiscountDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billingDiscountDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/billingdiscountdetailss")
  public XfR save(@RequestBody BillingDiscountDetails billingDiscountDetails) {
     return XfR.ok(billingDiscountDetailsServiceImpl.save(billingDiscountDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billingDiscountDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/billingdiscountdetailss/{id}")
  public XfR putUpdate(@RequestBody BillingDiscountDetails billingDiscountDetails,@PathVariable Long id) {
      billingDiscountDetails.setId(id);
      return XfR.ok(billingDiscountDetailsServiceImpl.updateById(billingDiscountDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billingDiscountDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billingdiscountdetailss/{id}")
  public XfR patchUpdate(@RequestBody BillingDiscountDetails billingDiscountDetails,@PathVariable Long id) {
      BillingDiscountDetails upbillingDiscountDetails = billingDiscountDetailsServiceImpl.getById(id);
      if(upbillingDiscountDetails != null){
        upbillingDiscountDetails = ObjectCopyUtils.copyProperties(billingDiscountDetails,upbillingDiscountDetails,true);
      }
      return XfR.ok(billingDiscountDetailsServiceImpl.updateById(upbillingDiscountDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billingdiscountdetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingDiscountDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/billingdiscountdetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_discount_details");
     params.put("request", condition);

     return XfR.ok(billingDiscountDetailsServiceImpl.querys(params));
  }

}
