package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.EmailConfig;
import com.xforceplus.ultraman.app.jcunilever.service.IEmailConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class EmailConfigController {

  @Autowired
  private IEmailConfigService emailConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param emailConfig ${table.comment}
   * @return
   */
  @GetMapping("/emailconfigs" )
  public XfR getEmailConfigs(XfPage page, EmailConfig emailConfig) {
    return XfR.ok(emailConfigServiceImpl.page(page, Wrappers.query(emailConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/emailconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(emailConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param emailConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/emailconfigs")
  public XfR save(@RequestBody EmailConfig emailConfig) {
     return XfR.ok(emailConfigServiceImpl.save(emailConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param emailConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/emailconfigs/{id}")
  public XfR putUpdate(@RequestBody EmailConfig emailConfig,@PathVariable Long id) {
      emailConfig.setId(id);
      return XfR.ok(emailConfigServiceImpl.updateById(emailConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param emailConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/emailconfigs/{id}")
  public XfR patchUpdate(@RequestBody EmailConfig emailConfig,@PathVariable Long id) {
      EmailConfig upemailConfig = emailConfigServiceImpl.getById(id);
      if(upemailConfig != null){
        upemailConfig = ObjectCopyUtils.copyProperties(emailConfig,upemailConfig,true);
      }
      return XfR.ok(emailConfigServiceImpl.updateById(upemailConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/emailconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(emailConfigServiceImpl.removeById(id));
  }

  @PostMapping("/emailconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "email_config");
     params.put("request", condition);

     return XfR.ok(emailConfigServiceImpl.querys(params));
  }

}
