package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.Producer;
import com.xforceplus.ultraman.app.jcunilever.service.IProducerService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class ProducerController {

  @Autowired
  private IProducerService producerServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param producer ${table.comment}
   * @return
   */
  @GetMapping("/producers" )
  public XfR getProducers(XfPage page, Producer producer) {
    return XfR.ok(producerServiceImpl.page(page, Wrappers.query(producer)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/producers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(producerServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param producer ${table.comment}
   * @return XfR
   */
  @PostMapping("/producers")
  public XfR save(@RequestBody Producer producer) {
     return XfR.ok(producerServiceImpl.save(producer));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param producer ${table.comment}
   * @return XfR
   */
  @PutMapping("/producers/{id}")
  public XfR putUpdate(@RequestBody Producer producer,@PathVariable Long id) {
      producer.setId(id);
      return XfR.ok(producerServiceImpl.updateById(producer));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param producer ${table.comment}
   * @return XfR
   */
  @PatchMapping("/producers/{id}")
  public XfR patchUpdate(@RequestBody Producer producer,@PathVariable Long id) {
      Producer upproducer = producerServiceImpl.getById(id);
      if(upproducer != null){
        upproducer = ObjectCopyUtils.copyProperties(producer,upproducer,true);
      }
      return XfR.ok(producerServiceImpl.updateById(upproducer));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/producers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(producerServiceImpl.removeById(id));
  }

  @PostMapping("/producers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "producer");
     params.put("request", condition);

     return XfR.ok(producerServiceImpl.querys(params));
  }

}
