package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.BillingInvoiceRelation;
import com.xforceplus.ultraman.app.jcunilever.service.IBillingInvoiceRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2023-07-17
 */
@RestController
public class BillingInvoiceRelationController {

  @Autowired
  private IBillingInvoiceRelationService billingInvoiceRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingInvoiceRelation OTC业务
   * @return
   */
  @GetMapping("/billinginvoicerelations" )
  public XfR getBillingInvoiceRelations(XfPage page, BillingInvoiceRelation billingInvoiceRelation) {
    return XfR.ok(billingInvoiceRelationServiceImpl.page(page, Wrappers.query(billingInvoiceRelation)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/billinginvoicerelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingInvoiceRelationServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param billingInvoiceRelation OTC业务
   * @return XfR
   */
  @PostMapping("/billinginvoicerelations")
  public XfR save(@RequestBody BillingInvoiceRelation billingInvoiceRelation) {
     return XfR.ok(billingInvoiceRelationServiceImpl.save(billingInvoiceRelation));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param billingInvoiceRelation OTC业务
   * @return XfR
   */
  @PutMapping("/billinginvoicerelations/{id}")
  public XfR putUpdate(@RequestBody BillingInvoiceRelation billingInvoiceRelation,@PathVariable Long id) {
      billingInvoiceRelation.setId(id);
      return XfR.ok(billingInvoiceRelationServiceImpl.updateById(billingInvoiceRelation));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param billingInvoiceRelation OTC业务
   * @return XfR
   */
  @PatchMapping("/billinginvoicerelations/{id}")
  public XfR patchUpdate(@RequestBody BillingInvoiceRelation billingInvoiceRelation,@PathVariable Long id) {
      BillingInvoiceRelation upbillingInvoiceRelation = billingInvoiceRelationServiceImpl.getById(id);
      if(upbillingInvoiceRelation != null){
        upbillingInvoiceRelation = ObjectCopyUtils.copyProperties(billingInvoiceRelation,upbillingInvoiceRelation,true);
      }
      return XfR.ok(billingInvoiceRelationServiceImpl.updateById(upbillingInvoiceRelation));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billinginvoicerelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingInvoiceRelationServiceImpl.removeById(id));
  }

  @PostMapping("/billinginvoicerelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_invoice_relation");
     params.put("request", condition);

     return XfR.ok(billingInvoiceRelationServiceImpl.querys(params));
  }

}
