package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.BillingTypeWriteOffConfig;
import com.xforceplus.ultraman.app.jcunilever.service.IBillingTypeWriteOffConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2023-07-17
 */
@RestController
public class BillingTypeWriteOffConfigController {

  @Autowired
  private IBillingTypeWriteOffConfigService billingTypeWriteOffConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingTypeWriteOffConfig OTC业务
   * @return
   */
  @GetMapping("/billingtypewriteoffconfigs" )
  public XfR getBillingTypeWriteOffConfigs(XfPage page, BillingTypeWriteOffConfig billingTypeWriteOffConfig) {
    return XfR.ok(billingTypeWriteOffConfigServiceImpl.page(page, Wrappers.query(billingTypeWriteOffConfig)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/billingtypewriteoffconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingTypeWriteOffConfigServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param billingTypeWriteOffConfig OTC业务
   * @return XfR
   */
  @PostMapping("/billingtypewriteoffconfigs")
  public XfR save(@RequestBody BillingTypeWriteOffConfig billingTypeWriteOffConfig) {
     return XfR.ok(billingTypeWriteOffConfigServiceImpl.save(billingTypeWriteOffConfig));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param billingTypeWriteOffConfig OTC业务
   * @return XfR
   */
  @PutMapping("/billingtypewriteoffconfigs/{id}")
  public XfR putUpdate(@RequestBody BillingTypeWriteOffConfig billingTypeWriteOffConfig,@PathVariable Long id) {
      billingTypeWriteOffConfig.setId(id);
      return XfR.ok(billingTypeWriteOffConfigServiceImpl.updateById(billingTypeWriteOffConfig));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param billingTypeWriteOffConfig OTC业务
   * @return XfR
   */
  @PatchMapping("/billingtypewriteoffconfigs/{id}")
  public XfR patchUpdate(@RequestBody BillingTypeWriteOffConfig billingTypeWriteOffConfig,@PathVariable Long id) {
      BillingTypeWriteOffConfig upbillingTypeWriteOffConfig = billingTypeWriteOffConfigServiceImpl.getById(id);
      if(upbillingTypeWriteOffConfig != null){
        upbillingTypeWriteOffConfig = ObjectCopyUtils.copyProperties(billingTypeWriteOffConfig,upbillingTypeWriteOffConfig,true);
      }
      return XfR.ok(billingTypeWriteOffConfigServiceImpl.updateById(upbillingTypeWriteOffConfig));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billingtypewriteoffconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingTypeWriteOffConfigServiceImpl.removeById(id));
  }

  @PostMapping("/billingtypewriteoffconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_type_write_off_config");
     params.put("request", condition);

     return XfR.ok(billingTypeWriteOffConfigServiceImpl.querys(params));
  }

}
