package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.BlobFiles;
import com.xforceplus.ultraman.app.jcunilever.service.IBlobFilesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2023-07-17
 */
@RestController
public class BlobFilesController {

  @Autowired
  private IBlobFilesService blobFilesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param blobFiles OTC业务
   * @return
   */
  @GetMapping("/blobfiless" )
  public XfR getBlobFiless(XfPage page, BlobFiles blobFiles) {
    return XfR.ok(blobFilesServiceImpl.page(page, Wrappers.query(blobFiles)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/blobfiless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(blobFilesServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param blobFiles OTC业务
   * @return XfR
   */
  @PostMapping("/blobfiless")
  public XfR save(@RequestBody BlobFiles blobFiles) {
     return XfR.ok(blobFilesServiceImpl.save(blobFiles));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param blobFiles OTC业务
   * @return XfR
   */
  @PutMapping("/blobfiless/{id}")
  public XfR putUpdate(@RequestBody BlobFiles blobFiles,@PathVariable Long id) {
      blobFiles.setId(id);
      return XfR.ok(blobFilesServiceImpl.updateById(blobFiles));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param blobFiles OTC业务
   * @return XfR
   */
  @PatchMapping("/blobfiless/{id}")
  public XfR patchUpdate(@RequestBody BlobFiles blobFiles,@PathVariable Long id) {
      BlobFiles upblobFiles = blobFilesServiceImpl.getById(id);
      if(upblobFiles != null){
        upblobFiles = ObjectCopyUtils.copyProperties(blobFiles,upblobFiles,true);
      }
      return XfR.ok(blobFilesServiceImpl.updateById(upblobFiles));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/blobfiless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(blobFilesServiceImpl.removeById(id));
  }

  @PostMapping("/blobfiless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "blob_files");
     params.put("request", condition);

     return XfR.ok(blobFilesServiceImpl.querys(params));
  }

}
