package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.NoInvoicedReasonConfig;
import com.xforceplus.ultraman.app.jcunilever.service.INoInvoicedReasonConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2023-07-17
 */
@RestController
public class NoInvoicedReasonConfigController {

  @Autowired
  private INoInvoicedReasonConfigService noInvoicedReasonConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param noInvoicedReasonConfig OTC业务
   * @return
   */
  @GetMapping("/noinvoicedreasonconfigs" )
  public XfR getNoInvoicedReasonConfigs(XfPage page, NoInvoicedReasonConfig noInvoicedReasonConfig) {
    return XfR.ok(noInvoicedReasonConfigServiceImpl.page(page, Wrappers.query(noInvoicedReasonConfig)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/noinvoicedreasonconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(noInvoicedReasonConfigServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param noInvoicedReasonConfig OTC业务
   * @return XfR
   */
  @PostMapping("/noinvoicedreasonconfigs")
  public XfR save(@RequestBody NoInvoicedReasonConfig noInvoicedReasonConfig) {
     return XfR.ok(noInvoicedReasonConfigServiceImpl.save(noInvoicedReasonConfig));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param noInvoicedReasonConfig OTC业务
   * @return XfR
   */
  @PutMapping("/noinvoicedreasonconfigs/{id}")
  public XfR putUpdate(@RequestBody NoInvoicedReasonConfig noInvoicedReasonConfig,@PathVariable Long id) {
      noInvoicedReasonConfig.setId(id);
      return XfR.ok(noInvoicedReasonConfigServiceImpl.updateById(noInvoicedReasonConfig));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param noInvoicedReasonConfig OTC业务
   * @return XfR
   */
  @PatchMapping("/noinvoicedreasonconfigs/{id}")
  public XfR patchUpdate(@RequestBody NoInvoicedReasonConfig noInvoicedReasonConfig,@PathVariable Long id) {
      NoInvoicedReasonConfig upnoInvoicedReasonConfig = noInvoicedReasonConfigServiceImpl.getById(id);
      if(upnoInvoicedReasonConfig != null){
        upnoInvoicedReasonConfig = ObjectCopyUtils.copyProperties(noInvoicedReasonConfig,upnoInvoicedReasonConfig,true);
      }
      return XfR.ok(noInvoicedReasonConfigServiceImpl.updateById(upnoInvoicedReasonConfig));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/noinvoicedreasonconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(noInvoicedReasonConfigServiceImpl.removeById(id));
  }

  @PostMapping("/noinvoicedreasonconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no_invoiced_reason_config");
     params.put("request", condition);

     return XfR.ok(noInvoicedReasonConfigServiceImpl.querys(params));
  }

}
