package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.InvoiceMatchInit;
import com.xforceplus.ultraman.app.jcunilever.service.IInvoiceMatchInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2023-11-21
 */
@RestController
public class InvoiceMatchInitController {

  @Autowired
  private IInvoiceMatchInitService invoiceMatchInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceMatchInit OTC业务
   * @return
   */
  @GetMapping("/invoicematchinits" )
  public XfR getInvoiceMatchInits(XfPage page, InvoiceMatchInit invoiceMatchInit) {
    return XfR.ok(invoiceMatchInitServiceImpl.page(page, Wrappers.query(invoiceMatchInit)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicematchinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceMatchInitServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param invoiceMatchInit OTC业务
   * @return XfR
   */
  @PostMapping("/invoicematchinits")
  public XfR save(@RequestBody InvoiceMatchInit invoiceMatchInit) {
     return XfR.ok(invoiceMatchInitServiceImpl.save(invoiceMatchInit));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param invoiceMatchInit OTC业务
   * @return XfR
   */
  @PutMapping("/invoicematchinits/{id}")
  public XfR putUpdate(@RequestBody InvoiceMatchInit invoiceMatchInit,@PathVariable Long id) {
      invoiceMatchInit.setId(id);
      return XfR.ok(invoiceMatchInitServiceImpl.updateById(invoiceMatchInit));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param invoiceMatchInit OTC业务
   * @return XfR
   */
  @PatchMapping("/invoicematchinits/{id}")
  public XfR patchUpdate(@RequestBody InvoiceMatchInit invoiceMatchInit,@PathVariable Long id) {
      InvoiceMatchInit upinvoiceMatchInit = invoiceMatchInitServiceImpl.getById(id);
      if(upinvoiceMatchInit != null){
        upinvoiceMatchInit = ObjectCopyUtils.copyProperties(invoiceMatchInit,upinvoiceMatchInit,true);
      }
      return XfR.ok(invoiceMatchInitServiceImpl.updateById(upinvoiceMatchInit));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicematchinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceMatchInitServiceImpl.removeById(id));
  }

  @PostMapping("/invoicematchinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_match_init");
     params.put("request", condition);

     return XfR.ok(invoiceMatchInitServiceImpl.querys(params));
  }

}
