package com.xforceplus.ultraman.app.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.OpenARVoucher;
import com.xforceplus.ultraman.app.jcunilever.service.IOpenARVoucherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2023-11-21
 */
@RestController
public class OpenARVoucherController {

  @Autowired
  private IOpenARVoucherService openARVoucherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param openARVoucher OTC业务
   * @return
   */
  @GetMapping("/openarvouchers" )
  public XfR getOpenARVouchers(XfPage page, OpenARVoucher openARVoucher) {
    return XfR.ok(openARVoucherServiceImpl.page(page, Wrappers.query(openARVoucher)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/openarvouchers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(openARVoucherServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param openARVoucher OTC业务
   * @return XfR
   */
  @PostMapping("/openarvouchers")
  public XfR save(@RequestBody OpenARVoucher openARVoucher) {
     return XfR.ok(openARVoucherServiceImpl.save(openARVoucher));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param openARVoucher OTC业务
   * @return XfR
   */
  @PutMapping("/openarvouchers/{id}")
  public XfR putUpdate(@RequestBody OpenARVoucher openARVoucher,@PathVariable Long id) {
      openARVoucher.setId(id);
      return XfR.ok(openARVoucherServiceImpl.updateById(openARVoucher));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param openARVoucher OTC业务
   * @return XfR
   */
  @PatchMapping("/openarvouchers/{id}")
  public XfR patchUpdate(@RequestBody OpenARVoucher openARVoucher,@PathVariable Long id) {
      OpenARVoucher upopenARVoucher = openARVoucherServiceImpl.getById(id);
      if(upopenARVoucher != null){
        upopenARVoucher = ObjectCopyUtils.copyProperties(openARVoucher,upopenARVoucher,true);
      }
      return XfR.ok(openARVoucherServiceImpl.updateById(upopenARVoucher));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/openarvouchers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(openARVoucherServiceImpl.removeById(id));
  }

  @PostMapping("/openarvouchers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "open_a_r_voucher");
     params.put("request", condition);

     return XfR.ok(openARVoucherServiceImpl.querys(params));
  }

}
