package com.xforceplus.ultraman.app.jcunilever6.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务部门
 * </p>
 *
 * @author ultraman
 * @since 2023-03-07
 */
public enum BusinessUnit {

    HPC("HPC", "HPC"),
    FS("FS", "FS"),
    FR("FR", "FR"),
    IC("IC", "IC");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessUnit(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessUnit fromCode(String code) {
        return Stream.of(BusinessUnit.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
