package com.xforceplus.ultraman.app.jcunilever6.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-07
 */
public enum FileStatus {

    _1("1", "待处理"),
    _2("2", "处理中"),
    _3("3", "已入库"),
    _4("4", "已归档"),
    _5("5", "处理异常"),
    _6("6", "已取消");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileStatus fromCode(String code) {
        return Stream.of(FileStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
