package com.xforceplus.ultraman.app.jcunilever6.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-07
 */
public enum HandleType {

    _0("0", "待处理"),
    _1("1", "已完成"),
    _2("2", "已取消 "),
    _3("3", "处理异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    HandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandleType fromCode(String code) {
        return Stream.of(HandleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
