package com.xforceplus.ultraman.app.jcunilever6.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 订单类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-07
 */
public enum OrderType {

    _0("0", "普通订单"),
    _1("1", "尾款(尾款已支付)"),
    _2("2", "尾款(已退款)"),
    _3("3", "定金(已退款)"),
    _4("4", "定金(尾款已支付)"),
    _5("5", "定金(尾款未支付)");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderType fromCode(String code) {
        return Stream.of(OrderType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
