package com.xforceplus.ultraman.app.jcunilever6.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办对象
 * </p>
 *
 * @author ultraman
 * @since 2023-03-07
 */
public enum ProduceObj {

    PUSH_BILLING("PushBilling", "推送billing单据"),
    PUSH_MDM("PushMdm", "推送mdm");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProduceObj(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceObj fromCode(String code) {
        return Stream.of(ProduceObj.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
