package com.xforceplus.ultraman.app.jcunilever6.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 快照格式
 * </p>
 *
 * @author ultraman
 * @since 2023-03-07
 */
public enum SnaphostFormat {

    _1("1", "直接存取"),
    _2("2", "文件存取"),
    DIRECT("direct", "直接存取"),
    FILE("file", "文件存取");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SnaphostFormat(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SnaphostFormat fromCode(String code) {
        return Stream.of(SnaphostFormat.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
