package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 订阅方名称
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum SubscriberName {

    EMAIL("EMAIL", "邮件订阅"),
    ORDER_END_CHECK_S_A_P("OrderEndCheckSAP", "SAP业务单月末对账"),
    ORDER_END_CHECK_E_A_S("OrderEndCheckEAS", "EAS业务单月末对账");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SubscriberName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubscriberName fromCode(String code){
        switch(code) {
            case "EMAIL":
                return EMAIL;
            case "OrderEndCheckSAP":
                return ORDER_END_CHECK_S_A_P;
            case "OrderEndCheckEAS":
                return ORDER_END_CHECK_E_A_S;
            default:
                return null;
        }
    }
}
