package com.xforceplus.ultraman.app.jcvankepurchaser.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SupplierCompany implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请流水号
   */
  @TableField("applySerialNo")
  private String applySerialNo;

  /**
   * 申请批次号
   */
  @TableField("applyBatchNo")
  private String applyBatchNo;

  /**
   * 分组代码
   */
  @TableField("groupCode")
  private String groupCode;

  /**
   * 公司编号
   */
  @TableField("companyNo")
  private String companyNo;

  /**
   * 公司类型
   */
  @TableField("companyType")
  private String companyType;

  /**
   * 公司税号
   */
  @TableField("companyTaxNo")
  private String companyTaxNo;

  /**
   * 公司全称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 公司地址
   */
  @TableField("companyAddr")
  private String companyAddr;

  /**
   * 公司电话
   */
  @TableField("companyTel")
  private String companyTel;

  /**
   * 纳税人类型
   */
  @TableField("taxpayerType")
  private String taxpayerType;

  /**
   * 联系人姓名
   */
  @TableField("contactorName")
  private String contactorName;

  /**
   * 联系人邮箱
   */
  @TableField("contactorEmail")
  private String contactorEmail;

  /**
   * 联系人电话
   */
  @TableField("contactorPhone")
  private String contactorPhone;

  /**
   * 联系人手机（短信）
   */
  @TableField("contactorTel")
  private String contactorTel;

  /**
   * 公司银行名称
   */
  @TableField("companyBankName")
  private String companyBankName;

  /**
   * 公司银行账号
   */
  @TableField("companyBankAccount")
  private String companyBankAccount;

  /**
   * 收款人姓名
   */
  @TableField("cashierName")
  private String cashierName;

  /**
   * 复核人姓名
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 开票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 普票票面限制金额
   */
  @TableField("invoiceLimitAmountC")
  private BigDecimal invoiceLimitAmountC;

  /**
   * 专票票面限制金额
   */
  @TableField("invoiceLimitAmountS")
  private BigDecimal invoiceLimitAmountS;

  /**
   * 税控盘类型
   */
  @TableField("taxDiskType")
  private String taxDiskType;

  /**
   * 开票用户
   */
  @TableField("invoiceMaker")
  private String invoiceMaker;

  /**
   * 开票用户邮箱
   */
  @TableField("invoiceEmail")
  private String invoiceEmail;

  /**
   * 申请人姓名
   */
  @TableField("applyUserName")
  private String applyUserName;

  /**
   * 申请人邮箱
   */
  @TableField("applyUserEmail")
  private String applyUserEmail;

  /**
   * 申请人电话
   */
  @TableField("applyUserPhone")
  private String applyUserPhone;

  /**
   * 是否新建账号
   */
  @TableField("isCreateUser")
  private String isCreateUser;

  /**
   * 审核材料链接
   */
  @TableField("auditFileUrl")
  private String auditFileUrl;

  /**
   * 统一社会信用代码
   */
  @TableField("unCrediCCode")
  private String unCrediCCode;

  /**
   * 税务登记地址
   */
  private String taxddress;

  /**
   * 税务电话
   */
  @TableField("taxPhone")
  private String taxPhone;

  /**
   * 改变时间
   */
  @TableField("alteratioTTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime alteratioTTime;

  /**
   * 变更后公司角色类型
   */
  @TableField("newCompanyRoleType")
  private String newCompanyRoleType;

  /**
   * 变更后公司税号
   */
  @TableField("newCompanyTaxNo")
  private String newCompanyTaxNo;

  /**
   * 变更后公司名称
   */
  @TableField("newCompanyName")
  private String newCompanyName;

  /**
   * 变更后开票用户
   */
  @TableField("newInvoiceMaker")
  private String newInvoiceMaker;

  /**
   * 处理状态
   */
  @TableField("disposeStatus")
  private String disposeStatus;

  /**
   * 处理信息
   */
  @TableField("disposeInfo")
  private String disposeInfo;

  /**
   * 处理时间
   */
  @TableField("disposeDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime disposeDate;

  /**
   * 同步时间
   */
  @TableField("syncTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime syncTime;

  /**
   * 备注
   */
  private String remark;

  /**
   * 供应商编号（副 - 存入后入的供应商编号）
   */
  @TableField("companyDeputyNo")
  private String companyDeputyNo;

  /**
   * pdc供应商编号
   */
  @TableField("supplierMdmNum")
  private String supplierMdmNum;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 审核状态
   */
  @TableField("auditState")
  private String auditState;

  /**
   * 申请变更类型
   */
  @TableField("applyModifyType")
  private String applyModifyType;

  /**
   * 协同标记
   */
  @TableField("isSynergetics")
  private String isSynergetics;

  /**
   * 公司角色类型
   */
  @TableField("companyRoleType")
  private String companyRoleType;

  /**
   * 来源系统
   */
  @TableField("dataFromSystem")
  private String dataFromSystem;

  /**
   * 是否启用
   */
  @TableField("inUsed")
  private String inUsed;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applySerialNo", applySerialNo);
      map.put("applyBatchNo", applyBatchNo);
      map.put("groupCode", groupCode);
      map.put("companyNo", companyNo);
      map.put("companyType", companyType);
      map.put("companyTaxNo", companyTaxNo);
      map.put("companyName", companyName);
      map.put("companyAddr", companyAddr);
      map.put("companyTel", companyTel);
      map.put("taxpayerType", taxpayerType);
      map.put("contactorName", contactorName);
      map.put("contactorEmail", contactorEmail);
      map.put("contactorPhone", contactorPhone);
      map.put("contactorTel", contactorTel);
      map.put("companyBankName", companyBankName);
      map.put("companyBankAccount", companyBankAccount);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoiceType", invoiceType);
      map.put("invoiceLimitAmountC", invoiceLimitAmountC);
      map.put("invoiceLimitAmountS", invoiceLimitAmountS);
      map.put("taxDiskType", taxDiskType);
      map.put("invoiceMaker", invoiceMaker);
      map.put("invoiceEmail", invoiceEmail);
      map.put("applyUserName", applyUserName);
      map.put("applyUserEmail", applyUserEmail);
      map.put("applyUserPhone", applyUserPhone);
      map.put("isCreateUser", isCreateUser);
      map.put("auditFileUrl", auditFileUrl);
      map.put("unCrediCCode", unCrediCCode);
      map.put("taxddress", taxddress);
      map.put("taxPhone", taxPhone);
      map.put("alteratioTTime", BocpGenUtils.toTimestamp(alteratioTTime));
      map.put("newCompanyRoleType", newCompanyRoleType);
      map.put("newCompanyTaxNo", newCompanyTaxNo);
      map.put("newCompanyName", newCompanyName);
      map.put("newInvoiceMaker", newInvoiceMaker);
      map.put("disposeStatus", disposeStatus);
      map.put("disposeInfo", disposeInfo);
      map.put("disposeDate", BocpGenUtils.toTimestamp(disposeDate));
      map.put("syncTime", BocpGenUtils.toTimestamp(syncTime));
      map.put("remark", remark);
      map.put("companyDeputyNo", companyDeputyNo);
      map.put("supplierMdmNum", supplierMdmNum);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("auditState", auditState);
      map.put("applyModifyType", applyModifyType);
      map.put("isSynergetics", isSynergetics);
      map.put("companyRoleType", companyRoleType);
      map.put("dataFromSystem", dataFromSystem);
      map.put("inUsed", inUsed);

      return map;
  }

  public static SupplierCompany fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SupplierCompany entity = new SupplierCompany();
    if(map.containsKey("applySerialNo")) {
      Object obj = map.get("applySerialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplySerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyBatchNo")) {
      Object obj = map.get("applyBatchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("groupCode")) {
      Object obj = map.get("groupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyNo")) {
      Object obj = map.get("companyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyType")) {
      Object obj = map.get("companyType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyAddr")) {
      Object obj = map.get("companyAddr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTel")) {
      Object obj = map.get("companyTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxpayerType")) {
      Object obj = map.get("taxpayerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxpayerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contactorName")) {
      Object obj = map.get("contactorName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContactorName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contactorEmail")) {
      Object obj = map.get("contactorEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContactorEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contactorPhone")) {
      Object obj = map.get("contactorPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContactorPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contactorTel")) {
      Object obj = map.get("contactorTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContactorTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyBankName")) {
      Object obj = map.get("companyBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyBankAccount")) {
      Object obj = map.get("companyBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceLimitAmountC")) {
      Object obj = map.get("invoiceLimitAmountC");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceLimitAmountC((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceLimitAmountC(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceLimitAmountC(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceLimitAmountC(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceLimitAmountC(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceLimitAmountS")) {
      Object obj = map.get("invoiceLimitAmountS");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceLimitAmountS((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceLimitAmountS(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceLimitAmountS(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceLimitAmountS(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceLimitAmountS(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxDiskType")) {
      Object obj = map.get("taxDiskType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxDiskType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceMaker")) {
      Object obj = map.get("invoiceMaker");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceMaker((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceEmail")) {
      Object obj = map.get("invoiceEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserName")) {
      Object obj = map.get("applyUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserEmail")) {
      Object obj = map.get("applyUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserPhone")) {
      Object obj = map.get("applyUserPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUserPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isCreateUser")) {
      Object obj = map.get("isCreateUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditFileUrl")) {
      Object obj = map.get("auditFileUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unCrediCCode")) {
      Object obj = map.get("unCrediCCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnCrediCCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxddress")) {
      Object obj = map.get("taxddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPhone")) {
      Object obj = map.get("taxPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alteratioTTime")) {
      Object obj = map.get("alteratioTTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAlteratioTTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAlteratioTTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlteratioTTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAlteratioTTime(null);
      }
    }
    if(map.containsKey("newCompanyRoleType")) {
      Object obj = map.get("newCompanyRoleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewCompanyRoleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newCompanyTaxNo")) {
      Object obj = map.get("newCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newCompanyName")) {
      Object obj = map.get("newCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newInvoiceMaker")) {
      Object obj = map.get("newInvoiceMaker");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewInvoiceMaker((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("disposeStatus")) {
      Object obj = map.get("disposeStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDisposeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("disposeInfo")) {
      Object obj = map.get("disposeInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDisposeInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("disposeDate")) {
      Object obj = map.get("disposeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDisposeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDisposeDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDisposeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDisposeDate(null);
      }
    }
    if(map.containsKey("syncTime")) {
      Object obj = map.get("syncTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSyncTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSyncTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSyncTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSyncTime(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyDeputyNo")) {
      Object obj = map.get("companyDeputyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyDeputyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierMdmNum")) {
      Object obj = map.get("supplierMdmNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierMdmNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditState")) {
      Object obj = map.get("auditState");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyModifyType")) {
      Object obj = map.get("applyModifyType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyModifyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isSynergetics")) {
      Object obj = map.get("isSynergetics");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsSynergetics((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyRoleType")) {
      Object obj = map.get("companyRoleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyRoleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataFromSystem")) {
      Object obj = map.get("dataFromSystem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataFromSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inUsed")) {
      Object obj = map.get("inUsed");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInUsed((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("applySerialNo")) {
      Object obj = map.get("applySerialNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplySerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyBatchNo")) {
      Object obj = map.get("applyBatchNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("groupCode")) {
      Object obj = map.get("groupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyNo")) {
      Object obj = map.get("companyNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyType")) {
      Object obj = map.get("companyType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyAddr")) {
      Object obj = map.get("companyAddr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyAddr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyTel")) {
      Object obj = map.get("companyTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxpayerType")) {
      Object obj = map.get("taxpayerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxpayerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contactorName")) {
      Object obj = map.get("contactorName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContactorName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contactorEmail")) {
      Object obj = map.get("contactorEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContactorEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contactorPhone")) {
      Object obj = map.get("contactorPhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContactorPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contactorTel")) {
      Object obj = map.get("contactorTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContactorTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyBankName")) {
      Object obj = map.get("companyBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyBankAccount")) {
      Object obj = map.get("companyBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceLimitAmountC")) {
      Object obj = map.get("invoiceLimitAmountC");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceLimitAmountC((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceLimitAmountC(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceLimitAmountC(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceLimitAmountC(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceLimitAmountC(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceLimitAmountS")) {
      Object obj = map.get("invoiceLimitAmountS");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceLimitAmountS((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceLimitAmountS(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceLimitAmountS(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceLimitAmountS(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceLimitAmountS(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxDiskType")) {
      Object obj = map.get("taxDiskType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxDiskType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceMaker")) {
      Object obj = map.get("invoiceMaker");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceMaker((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceEmail")) {
      Object obj = map.get("invoiceEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUserName")) {
      Object obj = map.get("applyUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUserEmail")) {
      Object obj = map.get("applyUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUserPhone")) {
      Object obj = map.get("applyUserPhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUserPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isCreateUser")) {
      Object obj = map.get("isCreateUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsCreateUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditFileUrl")) {
      Object obj = map.get("auditFileUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditFileUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unCrediCCode")) {
      Object obj = map.get("unCrediCCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnCrediCCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxddress")) {
      Object obj = map.get("taxddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPhone")) {
      Object obj = map.get("taxPhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alteratioTTime")) {
      Object obj = map.get("alteratioTTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAlteratioTTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAlteratioTTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlteratioTTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAlteratioTTime(null);
      }
    }
    if(map.containsKey("newCompanyRoleType")) {
      Object obj = map.get("newCompanyRoleType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewCompanyRoleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("newCompanyTaxNo")) {
      Object obj = map.get("newCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("newCompanyName")) {
      Object obj = map.get("newCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("newInvoiceMaker")) {
      Object obj = map.get("newInvoiceMaker");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewInvoiceMaker((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("disposeStatus")) {
      Object obj = map.get("disposeStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDisposeStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("disposeInfo")) {
      Object obj = map.get("disposeInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDisposeInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("disposeDate")) {
      Object obj = map.get("disposeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDisposeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDisposeDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDisposeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDisposeDate(null);
      }
    }
    if(map.containsKey("syncTime")) {
      Object obj = map.get("syncTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSyncTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSyncTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSyncTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSyncTime(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyDeputyNo")) {
      Object obj = map.get("companyDeputyNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyDeputyNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierMdmNum")) {
      Object obj = map.get("supplierMdmNum");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierMdmNum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditState")) {
      Object obj = map.get("auditState");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditState((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyModifyType")) {
      Object obj = map.get("applyModifyType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyModifyType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isSynergetics")) {
      Object obj = map.get("isSynergetics");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsSynergetics((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyRoleType")) {
      Object obj = map.get("companyRoleType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyRoleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataFromSystem")) {
      Object obj = map.get("dataFromSystem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataFromSystem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inUsed")) {
      Object obj = map.get("inUsed");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInUsed((String)obj);
        }
      } else {
      }
    }
  }
}
