package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 申请变更类型
 * </p>
 *
 * @author ultraman
 * @since 2023-09-04
 */
public enum ApplyModifyType {

    _0("0", "公司角色变更"),
    _1("1", "税号变更"),
    _2("2", "名称变更"),
    _3("3", "开票用户变更"),
    _4("4", "其他信息变更"),
    _9("9", "注销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplyModifyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyModifyType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
