package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据发票状态
 * </p>
 *
 * @author ultraman
 * @since 2023-09-04
 */
public enum BillInvoiceStatus {

    UNINVOICED("UNINVOICED", "未开票"),
    PARTIAL("PARTIAL", "部分开票"),
    COMPLETED("COMPLETED", "完全开票"),
    S("S", "已审核"),
    V("V", "已勾选"),
    SV("SV", "已认证"),
    OTHER("OTHER", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillInvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillInvoiceStatus fromCode(String code){
        switch(code) {
            case "UNINVOICED":
                return UNINVOICED;
            case "PARTIAL":
                return PARTIAL;
            case "COMPLETED":
                return COMPLETED;
            case "S":
                return S;
            case "V":
                return V;
            case "SV":
                return SV;
            case "OTHER":
                return OTHER;
            default:
                return null;
        }
    }
}
