package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务来源
 * </p>
 *
 * @author ultraman
 * @since 2023-09-04
 */
public enum BusinessSource {

    S_A_P_COOPERATIVE("SAPCooperative", "SAP协同"),
    S_A_P_NON_COOPERATIVE("SAPNonCooperative", "SAP非协同"),
    E_A_S_NON_COOPERATIVE("EASNonCooperative", "EAS非协同");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessSource fromCode(String code){
        switch(code) {
            case "SAPCooperative":
                return S_A_P_COOPERATIVE;
            case "SAPNonCooperative":
                return S_A_P_NON_COOPERATIVE;
            case "EASNonCooperative":
                return E_A_S_NON_COOPERATIVE;
            default:
                return null;
        }
    }
}
