package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 一周中的某一天
 * </p>
 *
 * @author ultraman
 * @since 2023-09-04
 */
public enum DayOfWeek {

    _1("1", "周一"),
    _2("2", "周二"),
    _3("3", "周三"),
    _4("4", "周四"),
    _5("5", "周五"),
    _6("6", "周六"),
    _7("7", "周日"),
    _0("0", "无");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DayOfWeek(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DayOfWeek fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
