package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单认证状态
 * </p>
 *
 * @author ultraman
 * @since 2023-09-04
 */
public enum OrderAuthStatus {

    _0("0", "未勾选"),
    _1("1", "已勾选"),
    _2("2", "部分勾选"),
    _3("3", "勾选异常"),
    _4("4", "已确认抵扣"),
    _5("5", "抵扣异常"),
    _6("6", "部分抵扣");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OrderAuthStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderAuthStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
