package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 卡单原因
 * </p>
 *
 * @author ultraman
 * @since 2023-09-04
 */
public enum StuckReason {

    _1("1", "单可抵扣，发票全部为普票"),
    _2("2", "发票购方法人信息不存在或未维护到主数据中"),
    _3("3", "法人协同标识变更"),
    _4("4", "一般纳税人变更为小规模纳税人"),
    _5("5", "底账已同步票，但长时间没有获取到业务单关系"),
    _6("6", "勾选抵扣标识为空");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StuckReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StuckReason fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
