package com.xforceplus.ultraman.app.jcvankepurchaser.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 报表主数据
 * </p>
 *
 * @author ultraman
 * @since 2023-09-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Threshold implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 重算状态
   */
  @TableField("recalculationStatus")
  private String recalculationStatus;

  /**
   * 签收环节阈值时间类型
   */
  @TableField("thresholdSignTimeType")
  private String thresholdSignTimeType;

  /**
   * 扫描环节阈值时间类型
   */
  @TableField("thresholdScanTimeType")
  private String thresholdScanTimeType;

  /**
   * 审核环节阈值时间类型
   */
  @TableField("thresholdAuditTimeType")
  private String thresholdAuditTimeType;

  /**
   * 认证环节阈值时间类型
   */
  @TableField("thresholdApproveTimeType")
  private String thresholdApproveTimeType;

  /**
   * 签收环节预警值时间类型
   */
  @TableField("alertEarlySignTimeType")
  private String alertEarlySignTimeType;

  /**
   * 扫描环节预警值时间类型
   */
  @TableField("alertEarlyScanTimeType")
  private String alertEarlyScanTimeType;

  /**
   * 审核环节预警值时间类型
   */
  @TableField("alertEarlyAuditTimeType")
  private String alertEarlyAuditTimeType;

  /**
   * 认证环节预警值时间类型
   */
  @TableField("alertEarlyApproveTimeType")
  private String alertEarlyApproveTimeType;

  /**
   * 签收环节阈值是否修改
   */
  @TableField("isThresholdSignModified")
  private String isThresholdSignModified;

  /**
   * 扫描环节阈值是否修改
   */
  @TableField("isThresholdScanModified")
  private String isThresholdScanModified;

  /**
   * 审核环节阈值是否修改
   */
  @TableField("isThresholdAuditModified")
  private String isThresholdAuditModified;

  /**
   * 认证环节阈值是否修改
   */
  @TableField("isThresholdApproveModified")
  private String isThresholdApproveModified;

  /**
   * 签收环节预警值是否修改
   */
  @TableField("isAlertEarlySignModified")
  private String isAlertEarlySignModified;

  /**
   * 扫描环节预警值是否修改
   */
  @TableField("isAlertEarlyScanModified")
  private String isAlertEarlyScanModified;

  /**
   * 审核环节预警值是否修改
   */
  @TableField("isAlertEarlyAuditModified")
  private String isAlertEarlyAuditModified;

  /**
   * 认证环节预警值是否修改
   */
  @TableField("isAlertEarlyApproveModified")
  private String isAlertEarlyApproveModified;

  /**
   * 修改时间
   */
  @TableField("modificationTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime modificationTime;

  /**
   * 重算完成时间
   */
  @TableField("recalculateCompleteTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recalculateCompleteTime;

  /**
   * 签收环节阈值
   */
  @TableField("thresholdSign")
  private Long thresholdSign;

  /**
   * 扫描环节阈值
   */
  @TableField("thresholdScan")
  private Long thresholdScan;

  /**
   * 审核环节阈值
   */
  @TableField("thresholdAudit")
  private Long thresholdAudit;

  /**
   * 认证环节阈值
   */
  @TableField("thresholdApprove")
  private Long thresholdApprove;

  /**
   * 签收环节预警值
   */
  @TableField("alertEarlySign")
  private Long alertEarlySign;

  /**
   * 扫描环节预警值
   */
  @TableField("alertEarlyScan")
  private Long alertEarlyScan;

  /**
   * 审核环节预警值
   */
  @TableField("alertEarlyAudit")
  private Long alertEarlyAudit;

  /**
   * 认证环节预警值
   */
  @TableField("alertEarlyApprove")
  private Long alertEarlyApprove;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("recalculationStatus", recalculationStatus);
      map.put("thresholdSignTimeType", thresholdSignTimeType);
      map.put("thresholdScanTimeType", thresholdScanTimeType);
      map.put("thresholdAuditTimeType", thresholdAuditTimeType);
      map.put("thresholdApproveTimeType", thresholdApproveTimeType);
      map.put("alertEarlySignTimeType", alertEarlySignTimeType);
      map.put("alertEarlyScanTimeType", alertEarlyScanTimeType);
      map.put("alertEarlyAuditTimeType", alertEarlyAuditTimeType);
      map.put("alertEarlyApproveTimeType", alertEarlyApproveTimeType);
      map.put("isThresholdSignModified", isThresholdSignModified);
      map.put("isThresholdScanModified", isThresholdScanModified);
      map.put("isThresholdAuditModified", isThresholdAuditModified);
      map.put("isThresholdApproveModified", isThresholdApproveModified);
      map.put("isAlertEarlySignModified", isAlertEarlySignModified);
      map.put("isAlertEarlyScanModified", isAlertEarlyScanModified);
      map.put("isAlertEarlyAuditModified", isAlertEarlyAuditModified);
      map.put("isAlertEarlyApproveModified", isAlertEarlyApproveModified);
      map.put("modificationTime", BocpGenUtils.toTimestamp(modificationTime));
      map.put("recalculateCompleteTime", BocpGenUtils.toTimestamp(recalculateCompleteTime));
      map.put("thresholdSign", thresholdSign);
      map.put("thresholdScan", thresholdScan);
      map.put("thresholdAudit", thresholdAudit);
      map.put("thresholdApprove", thresholdApprove);
      map.put("alertEarlySign", alertEarlySign);
      map.put("alertEarlyScan", alertEarlyScan);
      map.put("alertEarlyAudit", alertEarlyAudit);
      map.put("alertEarlyApprove", alertEarlyApprove);

      return map;
  }

  public static Threshold fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Threshold entity = new Threshold();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recalculationStatus")) {
      Object obj = map.get("recalculationStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecalculationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thresholdSignTimeType")) {
      Object obj = map.get("thresholdSignTimeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThresholdSignTimeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thresholdScanTimeType")) {
      Object obj = map.get("thresholdScanTimeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThresholdScanTimeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thresholdAuditTimeType")) {
      Object obj = map.get("thresholdAuditTimeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThresholdAuditTimeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thresholdApproveTimeType")) {
      Object obj = map.get("thresholdApproveTimeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThresholdApproveTimeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alertEarlySignTimeType")) {
      Object obj = map.get("alertEarlySignTimeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAlertEarlySignTimeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alertEarlyScanTimeType")) {
      Object obj = map.get("alertEarlyScanTimeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAlertEarlyScanTimeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alertEarlyAuditTimeType")) {
      Object obj = map.get("alertEarlyAuditTimeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAlertEarlyAuditTimeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alertEarlyApproveTimeType")) {
      Object obj = map.get("alertEarlyApproveTimeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAlertEarlyApproveTimeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isThresholdSignModified")) {
      Object obj = map.get("isThresholdSignModified");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsThresholdSignModified((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isThresholdScanModified")) {
      Object obj = map.get("isThresholdScanModified");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsThresholdScanModified((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isThresholdAuditModified")) {
      Object obj = map.get("isThresholdAuditModified");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsThresholdAuditModified((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isThresholdApproveModified")) {
      Object obj = map.get("isThresholdApproveModified");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsThresholdApproveModified((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isAlertEarlySignModified")) {
      Object obj = map.get("isAlertEarlySignModified");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsAlertEarlySignModified((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isAlertEarlyScanModified")) {
      Object obj = map.get("isAlertEarlyScanModified");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsAlertEarlyScanModified((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isAlertEarlyAuditModified")) {
      Object obj = map.get("isAlertEarlyAuditModified");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsAlertEarlyAuditModified((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isAlertEarlyApproveModified")) {
      Object obj = map.get("isAlertEarlyApproveModified");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsAlertEarlyApproveModified((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("modificationTime")) {
      Object obj = map.get("modificationTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setModificationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setModificationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setModificationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setModificationTime(null);
      }
    }
    if(map.containsKey("recalculateCompleteTime")) {
      Object obj = map.get("recalculateCompleteTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecalculateCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRecalculateCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecalculateCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecalculateCompleteTime(null);
      }
    }
    if(map.containsKey("thresholdSign")) {
      Object obj = map.get("thresholdSign");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setThresholdSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThresholdSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThresholdSign(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("thresholdScan")) {
      Object obj = map.get("thresholdScan");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setThresholdScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThresholdScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThresholdScan(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("thresholdAudit")) {
      Object obj = map.get("thresholdAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setThresholdAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThresholdAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThresholdAudit(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("thresholdApprove")) {
      Object obj = map.get("thresholdApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setThresholdApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThresholdApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThresholdApprove(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("alertEarlySign")) {
      Object obj = map.get("alertEarlySign");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAlertEarlySign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlertEarlySign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlertEarlySign(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("alertEarlyScan")) {
      Object obj = map.get("alertEarlyScan");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAlertEarlyScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlertEarlyScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlertEarlyScan(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("alertEarlyAudit")) {
      Object obj = map.get("alertEarlyAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAlertEarlyAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlertEarlyAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlertEarlyAudit(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("alertEarlyApprove")) {
      Object obj = map.get("alertEarlyApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAlertEarlyApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlertEarlyApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlertEarlyApprove(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recalculationStatus")) {
      Object obj = map.get("recalculationStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecalculationStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("thresholdSignTimeType")) {
      Object obj = map.get("thresholdSignTimeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThresholdSignTimeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("thresholdScanTimeType")) {
      Object obj = map.get("thresholdScanTimeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThresholdScanTimeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("thresholdAuditTimeType")) {
      Object obj = map.get("thresholdAuditTimeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThresholdAuditTimeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("thresholdApproveTimeType")) {
      Object obj = map.get("thresholdApproveTimeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThresholdApproveTimeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alertEarlySignTimeType")) {
      Object obj = map.get("alertEarlySignTimeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAlertEarlySignTimeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alertEarlyScanTimeType")) {
      Object obj = map.get("alertEarlyScanTimeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAlertEarlyScanTimeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alertEarlyAuditTimeType")) {
      Object obj = map.get("alertEarlyAuditTimeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAlertEarlyAuditTimeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alertEarlyApproveTimeType")) {
      Object obj = map.get("alertEarlyApproveTimeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAlertEarlyApproveTimeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isThresholdSignModified")) {
      Object obj = map.get("isThresholdSignModified");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsThresholdSignModified((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isThresholdScanModified")) {
      Object obj = map.get("isThresholdScanModified");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsThresholdScanModified((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isThresholdAuditModified")) {
      Object obj = map.get("isThresholdAuditModified");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsThresholdAuditModified((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isThresholdApproveModified")) {
      Object obj = map.get("isThresholdApproveModified");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsThresholdApproveModified((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isAlertEarlySignModified")) {
      Object obj = map.get("isAlertEarlySignModified");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsAlertEarlySignModified((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isAlertEarlyScanModified")) {
      Object obj = map.get("isAlertEarlyScanModified");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsAlertEarlyScanModified((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isAlertEarlyAuditModified")) {
      Object obj = map.get("isAlertEarlyAuditModified");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsAlertEarlyAuditModified((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isAlertEarlyApproveModified")) {
      Object obj = map.get("isAlertEarlyApproveModified");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsAlertEarlyApproveModified((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("modificationTime")) {
      Object obj = map.get("modificationTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setModificationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setModificationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setModificationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setModificationTime(null);
      }
    }
    if(map.containsKey("recalculateCompleteTime")) {
      Object obj = map.get("recalculateCompleteTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecalculateCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRecalculateCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRecalculateCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRecalculateCompleteTime(null);
      }
    }
    if(map.containsKey("thresholdSign")) {
      Object obj = map.get("thresholdSign");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setThresholdSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThresholdSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setThresholdSign(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("thresholdScan")) {
      Object obj = map.get("thresholdScan");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setThresholdScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThresholdScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setThresholdScan(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("thresholdAudit")) {
      Object obj = map.get("thresholdAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setThresholdAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThresholdAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setThresholdAudit(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("thresholdApprove")) {
      Object obj = map.get("thresholdApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setThresholdApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThresholdApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setThresholdApprove(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("alertEarlySign")) {
      Object obj = map.get("alertEarlySign");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAlertEarlySign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlertEarlySign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlertEarlySign(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("alertEarlyScan")) {
      Object obj = map.get("alertEarlyScan");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAlertEarlyScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlertEarlyScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlertEarlyScan(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("alertEarlyAudit")) {
      Object obj = map.get("alertEarlyAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAlertEarlyAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlertEarlyAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlertEarlyAudit(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("alertEarlyApprove")) {
      Object obj = map.get("alertEarlyApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAlertEarlyApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlertEarlyApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlertEarlyApprove(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
