package com.xforceplus.ultraman.app.jcvankepurchaser.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-09-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class UserPerformance implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 员工姓名
   */
  @TableField("userName")
  private String userName;

  /**
   * 邮包签收数量
   */
  @TableField("parcelSignCount")
  private Long parcelSignCount;

  /**
   * 业务单签收数量
   */
  @TableField("orderSignCount")
  private Long orderSignCount;

  /**
   * 发票签收数量
   */
  @TableField("invoiceSignCount")
  private Long invoiceSignCount;

  /**
   * 发票识别数量
   */
  @TableField("invoiceRecog")
  private Long invoiceRecog;

  /**
   * 发票审核数量
   */
  @TableField("invoiceAuditCount")
  private Long invoiceAuditCount;

  /**
   * 发票认证数量
   */
  @TableField("invoiceAuthCount")
  private Long invoiceAuthCount;

  /**
   * 风险邮包数量
   */
  @TableField("riskParcelCount")
  private Long riskParcelCount;

  /**
   * 风险单据数量
   */
  @TableField("riskOrderCount")
  private Long riskOrderCount;

  /**
   * 风险发票数量
   */
  @TableField("riskInvoiceCount")
  private Long riskInvoiceCount;

  /**
   * 工作日期
   */
  @TableField("workDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime workDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("userName", userName);
      map.put("parcelSignCount", parcelSignCount);
      map.put("orderSignCount", orderSignCount);
      map.put("invoiceSignCount", invoiceSignCount);
      map.put("invoiceRecog", invoiceRecog);
      map.put("invoiceAuditCount", invoiceAuditCount);
      map.put("invoiceAuthCount", invoiceAuthCount);
      map.put("riskParcelCount", riskParcelCount);
      map.put("riskOrderCount", riskOrderCount);
      map.put("riskInvoiceCount", riskInvoiceCount);
      map.put("workDate", BocpGenUtils.toTimestamp(workDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static UserPerformance fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    UserPerformance entity = new UserPerformance();
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parcelSignCount")) {
      Object obj = map.get("parcelSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParcelSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setParcelSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setParcelSignCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderSignCount")) {
      Object obj = map.get("orderSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderSignCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSignCount")) {
      Object obj = map.get("invoiceSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceSignCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceRecog")) {
      Object obj = map.get("invoiceRecog");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceRecog((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceRecog(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceRecog(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAuditCount")) {
      Object obj = map.get("invoiceAuditCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceAuditCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAuditCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAuditCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAuthCount")) {
      Object obj = map.get("invoiceAuthCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceAuthCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAuthCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAuthCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riskParcelCount")) {
      Object obj = map.get("riskParcelCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiskParcelCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiskParcelCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRiskParcelCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riskOrderCount")) {
      Object obj = map.get("riskOrderCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiskOrderCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiskOrderCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRiskOrderCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riskInvoiceCount")) {
      Object obj = map.get("riskInvoiceCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiskInvoiceCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiskInvoiceCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRiskInvoiceCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("workDate")) {
      Object obj = map.get("workDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWorkDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setWorkDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWorkDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setWorkDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parcelSignCount")) {
      Object obj = map.get("parcelSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setParcelSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setParcelSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setParcelSignCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderSignCount")) {
      Object obj = map.get("orderSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderSignCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceSignCount")) {
      Object obj = map.get("invoiceSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceSignCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceRecog")) {
      Object obj = map.get("invoiceRecog");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceRecog((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceRecog(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceRecog(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAuditCount")) {
      Object obj = map.get("invoiceAuditCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceAuditCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAuditCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAuditCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAuthCount")) {
      Object obj = map.get("invoiceAuthCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceAuthCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAuthCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAuthCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("riskParcelCount")) {
      Object obj = map.get("riskParcelCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRiskParcelCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRiskParcelCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRiskParcelCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("riskOrderCount")) {
      Object obj = map.get("riskOrderCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRiskOrderCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRiskOrderCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRiskOrderCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("riskInvoiceCount")) {
      Object obj = map.get("riskInvoiceCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRiskInvoiceCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRiskInvoiceCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRiskInvoiceCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("workDate")) {
      Object obj = map.get("workDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWorkDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setWorkDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWorkDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setWorkDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
