package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * making_reason
 * </p>
 *
 * @author ultraman
 * @since 2023-12-12
 */
public enum MakingReason {

    SALES_RETURN("sales_return", "销货退回"),
    MAKING_ERROR("making_error", "开票有误"),
    TAXABLE_SERVICE_END("taxable_service_end", "应税服务终止"),
    SALES_ALLOWANCE("sales_allowance", "发生销售折让");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MakingReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MakingReason fromCode(String code){
        switch(code) {
            case "sales_return":
                return SALES_RETURN;
            case "making_error":
                return MAKING_ERROR;
            case "taxable_service_end":
                return TAXABLE_SERVICE_END;
            case "sales_allowance":
                return SALES_ALLOWANCE;
            default:
                return null;
        }
    }
}
