package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * order_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-12
 */
public enum OrderStatus {

    Y("Y", "正常"),
    C("C", "作废"),
    D("D", "删除"),
    W("W", "撤回");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderStatus fromCode(String code){
        switch(code) {
            case "Y":
                return Y;
            case "C":
                return C;
            case "D":
                return D;
            case "W":
                return W;
            default:
                return null;
        }
    }
}
