package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * subscriber_name
 * </p>
 *
 * @author ultraman
 * @since 2023-12-12
 */
public enum SubscriberName {

    EMAIL("EMAIL", "邮件订阅"),
    ORDER_END_CHECK_S_A_P("OrderEndCheckSAP", "SAP业务单月末对账"),
    ORDER_END_CHECK_E_A_S("OrderEndCheckEAS", "EAS业务单月末对账"),
    OVERDUED_SIGN("OverduedSign", "签收超期"),
    OVERDUED_SCAN("OverduedScan", "扫描超期"),
    OVERDUED_AUDIT("OverduedAudit", "审核超期"),
    OVERDUED_AUTH("OverduedAuth", "勾选超期"),
    ALERT_EARLY_SIGN("alertEarlySign", "签收预警"),
    ALERT_EARLY_SCAN("alertEarlyScan", "扫描预警"),
    ALERT_EARLY_AUDIT("alertEarlyAudit", "审核预警"),
    ALERT_EARLY_AUTH("alertEarlyAuth", "勾选预警"),
    RECALCULATION("recalculation", "生命周期重算"),
    ORDER_SYNC("orderSync", "业务单同步");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SubscriberName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubscriberName fromCode(String code){
        switch(code) {
            case "EMAIL":
                return EMAIL;
            case "OrderEndCheckSAP":
                return ORDER_END_CHECK_S_A_P;
            case "OrderEndCheckEAS":
                return ORDER_END_CHECK_E_A_S;
            case "OverduedSign":
                return OVERDUED_SIGN;
            case "OverduedScan":
                return OVERDUED_SCAN;
            case "OverduedAudit":
                return OVERDUED_AUDIT;
            case "OverduedAuth":
                return OVERDUED_AUTH;
            case "alertEarlySign":
                return ALERT_EARLY_SIGN;
            case "alertEarlyScan":
                return ALERT_EARLY_SCAN;
            case "alertEarlyAudit":
                return ALERT_EARLY_AUDIT;
            case "alertEarlyAuth":
                return ALERT_EARLY_AUTH;
            case "recalculation":
                return RECALCULATION;
            case "orderSync":
                return ORDER_SYNC;
            default:
                return null;
        }
    }
}
