package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * taxpayer_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-12
 */
public enum TaxpayerTypeEnum {

    _0("0", "小规模纳税人"),
    _1("1", "一般纳税人");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxpayerTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxpayerTypeEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
