package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * time_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-12
 */
public enum TimeType {

    MINUTE("minute", "分钟"),
    HOUR("hour", "小时");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TimeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TimeType fromCode(String code){
        switch(code) {
            case "minute":
                return MINUTE;
            case "hour":
                return HOUR;
            default:
                return null;
        }
    }
}
