package com.xforceplus.ultraman.app.jcvankepurchaser.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 报表
 * </p>
 *
 * @author ultraman
 * @since 2023-12-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderLifeCircle implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 签收是否超期
   */
  @TableField("isOverDuedSign")
  private String isOverDuedSign;

  /**
   * 扫描是否超期
   */
  @TableField("isOverDuedScan")
  private String isOverDuedScan;

  /**
   * 审核是否超期
   */
  @TableField("isOverDuedAudit")
  private String isOverDuedAudit;

  /**
   * 认证是否超期
   */
  @TableField("isOverDuedApprove")
  private String isOverDuedApprove;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 业务单号
   */
  private String bizOrderNo;

  /**
   * 业务来源
   */
  @TableField("businessSource")
  private String businessSource;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 是否可抵扣
   */
  @TableField("canDeduction")
  private String canDeduction;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 业务单协同标识
   */
  private String cooperateFlag;

  /**
   * 来源系统
   */
  @TableField("dataFromSystem")
  private String dataFromSystem;

  /**
   * 单据签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billSignTime;

  /**
   * 扫描时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recogTime;

  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditTime;

  /**
   * 勾选时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;

  /**
   * 邮包签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime parcelSignTime;

  /**
   * 是否超期
   */
  @TableField("isOverDued")
  private String isOverDued;

  /**
   * 是否重算
   */
  @TableField("isRecalculation")
  private String isRecalculation;

  /**
   * 签收环节阈值
   */
  @TableField("thresholdSign")
  private Long thresholdSign;

  /**
   * 扫描环节阈值
   */
  @TableField("thresholdScan")
  private Long thresholdScan;

  /**
   * 审核环节阈值
   */
  @TableField("thresholdAudit")
  private Long thresholdAudit;

  /**
   * 认证环节阈值
   */
  @TableField("thresholdApprove")
  private Long thresholdApprove;

  /**
   * 签收超期时长
   */
  @TableField("overDueTimeSign")
  private Long overDueTimeSign;

  /**
   * 扫描超期时长
   */
  @TableField("overDueTimeScan")
  private Long overDueTimeScan;

  /**
   * 审核超期时长
   */
  @TableField("overDueTimeAudit")
  private Long overDueTimeAudit;

  /**
   * 认证超期时长
   */
  @TableField("overDueTimeApprove")
  private Long overDueTimeApprove;

  /**
   * 签收操作时长
   */
  @TableField("workTimeSign")
  private Long workTimeSign;

  /**
   * 扫描操作时长
   */
  @TableField("workTimeScan")
  private Long workTimeScan;

  /**
   * 审核操作时长
   */
  @TableField("workTimeAudit")
  private Long workTimeAudit;

  /**
   * 认证操作时长
   */
  @TableField("workTimeApprove")
  private Long workTimeApprove;

  /**
   * 平台业务单id
   */
  @TableField("bizOrderId")
  private Long bizOrderId;

  /**
   * 单据认证状态
   */
  @TableField("authStatus")
  private String authStatus;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;


  /**
   * 对一关联关系 关联对象 threshold
   */
    private Long thresholdId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("isOverDuedSign", isOverDuedSign);
      map.put("isOverDuedScan", isOverDuedScan);
      map.put("isOverDuedAudit", isOverDuedAudit);
      map.put("isOverDuedApprove", isOverDuedApprove);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("biz_order_no", bizOrderNo);
      map.put("businessSource", businessSource);
      map.put("purchaserName", purchaserName);
      map.put("canDeduction", canDeduction);
      map.put("invoice_type", invoiceType);
      map.put("cooperate_flag", cooperateFlag);
      map.put("dataFromSystem", dataFromSystem);
      map.put("bill_sign_time", BocpGenUtils.toTimestamp(billSignTime));
      map.put("recog_time", BocpGenUtils.toTimestamp(recogTime));
      map.put("audit_time", BocpGenUtils.toTimestamp(auditTime));
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("parcel_sign_time", BocpGenUtils.toTimestamp(parcelSignTime));
      map.put("isOverDued", isOverDued);
      map.put("isRecalculation", isRecalculation);
      map.put("thresholdSign", thresholdSign);
      map.put("thresholdScan", thresholdScan);
      map.put("thresholdAudit", thresholdAudit);
      map.put("thresholdApprove", thresholdApprove);
      map.put("overDueTimeSign", overDueTimeSign);
      map.put("overDueTimeScan", overDueTimeScan);
      map.put("overDueTimeAudit", overDueTimeAudit);
      map.put("overDueTimeApprove", overDueTimeApprove);
      map.put("workTimeSign", workTimeSign);
      map.put("workTimeScan", workTimeScan);
      map.put("workTimeAudit", workTimeAudit);
      map.put("workTimeApprove", workTimeApprove);
      map.put("bizOrderId", bizOrderId);
      map.put("authStatus", authStatus);
      map.put("purchaserTaxNo", purchaserTaxNo);

       map.put("threshold.id", thresholdId);
      return map;
  }

  public static OrderLifeCircle fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderLifeCircle entity = new OrderLifeCircle();
    if(map.containsKey("isOverDuedSign")) {
      Object obj = map.get("isOverDuedSign");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsOverDuedSign((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isOverDuedScan")) {
      Object obj = map.get("isOverDuedScan");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsOverDuedScan((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isOverDuedAudit")) {
      Object obj = map.get("isOverDuedAudit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsOverDuedAudit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isOverDuedApprove")) {
      Object obj = map.get("isOverDuedApprove");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsOverDuedApprove((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessSource")) {
      Object obj = map.get("businessSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("canDeduction")) {
      Object obj = map.get("canDeduction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCanDeduction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCooperateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataFromSystem")) {
      Object obj = map.get("dataFromSystem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataFromSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_sign_time")) {
      Object obj = map.get("bill_sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillSignTime(null);
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecogTime(null);
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditTime(null);
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("parcel_sign_time")) {
      Object obj = map.get("parcel_sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParcelSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setParcelSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setParcelSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setParcelSignTime(null);
      }
    }
    if(map.containsKey("isOverDued")) {
      Object obj = map.get("isOverDued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsOverDued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isRecalculation")) {
      Object obj = map.get("isRecalculation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsRecalculation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thresholdSign")) {
      Object obj = map.get("thresholdSign");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setThresholdSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThresholdSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThresholdSign(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("thresholdScan")) {
      Object obj = map.get("thresholdScan");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setThresholdScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThresholdScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThresholdScan(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("thresholdAudit")) {
      Object obj = map.get("thresholdAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setThresholdAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThresholdAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThresholdAudit(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("thresholdApprove")) {
      Object obj = map.get("thresholdApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setThresholdApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThresholdApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThresholdApprove(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("overDueTimeSign")) {
      Object obj = map.get("overDueTimeSign");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOverDueTimeSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOverDueTimeSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOverDueTimeSign(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("overDueTimeScan")) {
      Object obj = map.get("overDueTimeScan");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOverDueTimeScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOverDueTimeScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOverDueTimeScan(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("overDueTimeAudit")) {
      Object obj = map.get("overDueTimeAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOverDueTimeAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOverDueTimeAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOverDueTimeAudit(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("overDueTimeApprove")) {
      Object obj = map.get("overDueTimeApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOverDueTimeApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOverDueTimeApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOverDueTimeApprove(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("workTimeSign")) {
      Object obj = map.get("workTimeSign");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWorkTimeSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWorkTimeSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWorkTimeSign(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("workTimeScan")) {
      Object obj = map.get("workTimeScan");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWorkTimeScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWorkTimeScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWorkTimeScan(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("workTimeAudit")) {
      Object obj = map.get("workTimeAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWorkTimeAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWorkTimeAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWorkTimeAudit(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("workTimeApprove")) {
      Object obj = map.get("workTimeApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWorkTimeApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWorkTimeApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWorkTimeApprove(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderId")) {
      Object obj = map.get("bizOrderId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBizOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("threshold.id")) {
        Object obj = map.get("threshold.id");
      if(obj instanceof Long) {
        entity.setThresholdId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setThresholdId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("isOverDuedSign")) {
      Object obj = map.get("isOverDuedSign");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsOverDuedSign((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isOverDuedScan")) {
      Object obj = map.get("isOverDuedScan");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsOverDuedScan((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isOverDuedAudit")) {
      Object obj = map.get("isOverDuedAudit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsOverDuedAudit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isOverDuedApprove")) {
      Object obj = map.get("isOverDuedApprove");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsOverDuedApprove((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessSource")) {
      Object obj = map.get("businessSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("canDeduction")) {
      Object obj = map.get("canDeduction");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCanDeduction((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCooperateFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataFromSystem")) {
      Object obj = map.get("dataFromSystem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataFromSystem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_sign_time")) {
      Object obj = map.get("bill_sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillSignTime(null);
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRecogTime(null);
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuditTime(null);
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("parcel_sign_time")) {
      Object obj = map.get("parcel_sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setParcelSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setParcelSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setParcelSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setParcelSignTime(null);
      }
    }
    if(map.containsKey("isOverDued")) {
      Object obj = map.get("isOverDued");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsOverDued((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isRecalculation")) {
      Object obj = map.get("isRecalculation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsRecalculation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("thresholdSign")) {
      Object obj = map.get("thresholdSign");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setThresholdSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThresholdSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setThresholdSign(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("thresholdScan")) {
      Object obj = map.get("thresholdScan");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setThresholdScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThresholdScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setThresholdScan(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("thresholdAudit")) {
      Object obj = map.get("thresholdAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setThresholdAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThresholdAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setThresholdAudit(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("thresholdApprove")) {
      Object obj = map.get("thresholdApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setThresholdApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThresholdApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setThresholdApprove(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("overDueTimeSign")) {
      Object obj = map.get("overDueTimeSign");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOverDueTimeSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOverDueTimeSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOverDueTimeSign(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("overDueTimeScan")) {
      Object obj = map.get("overDueTimeScan");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOverDueTimeScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOverDueTimeScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOverDueTimeScan(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("overDueTimeAudit")) {
      Object obj = map.get("overDueTimeAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOverDueTimeAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOverDueTimeAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOverDueTimeAudit(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("overDueTimeApprove")) {
      Object obj = map.get("overDueTimeApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOverDueTimeApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOverDueTimeApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOverDueTimeApprove(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("workTimeSign")) {
      Object obj = map.get("workTimeSign");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWorkTimeSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWorkTimeSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setWorkTimeSign(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("workTimeScan")) {
      Object obj = map.get("workTimeScan");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWorkTimeScan((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWorkTimeScan(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setWorkTimeScan(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("workTimeAudit")) {
      Object obj = map.get("workTimeAudit");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWorkTimeAudit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWorkTimeAudit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setWorkTimeAudit(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("workTimeApprove")) {
      Object obj = map.get("workTimeApprove");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWorkTimeApprove((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWorkTimeApprove(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setWorkTimeApprove(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("bizOrderId")) {
      Object obj = map.get("bizOrderId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBizOrderId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("threshold.id")) {
        Object obj = map.get("threshold.id");
        if(obj instanceof Long) {
          this.setThresholdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThresholdId(Long.parseLong((String)obj));
        }
      }
  }
}
