package com.xforceplus.ultraman.app.jcvankepurchaser.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 报表主数据
 * </p>
 *
 * @author ultraman
 * @since 2023-12-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PerpetualCalendar implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 年
   */
  private String year;

  /**
   * 月
   */
  private String month;

  /**
   * 日
   */
  private String day;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否为特殊日子
   */
  @TableField("isSpecial")
  private String isSpecial;

  /**
   * 是否为工作日
   */
  @TableField("isWorkday")
  private String isWorkday;

  /**
   * 上午开始时间
   */
  @TableField("amBegin")
  private String amBegin;

  /**
   * 上午结束时间
   */
  @TableField("amEnd")
  private String amEnd;

  /**
   * 下午开始时间
   */
  @TableField("pmBegin")
  private String pmBegin;

  /**
   * 下午结束时间
   */
  @TableField("pmEnd")
  private String pmEnd;

  /**
   * 工作时长
   */
  @TableField("runingHour")
  private Long runingHour;

  /**
   * 一周中的某一天
   */
  private String weekday;

  /**
   * 年月日
   */
  @TableField("yearMonthDay")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime yearMonthDay;

  /**
   * 日期类型
   */
  @TableField("dataType")
  private String dataType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("year", year);
      map.put("month", month);
      map.put("day", day);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("isSpecial", isSpecial);
      map.put("isWorkday", isWorkday);
      map.put("amBegin", amBegin);
      map.put("amEnd", amEnd);
      map.put("pmBegin", pmBegin);
      map.put("pmEnd", pmEnd);
      map.put("runingHour", runingHour);
      map.put("weekday", weekday);
      map.put("yearMonthDay", BocpGenUtils.toTimestamp(yearMonthDay));
      map.put("dataType", dataType);

      return map;
  }

  public static PerpetualCalendar fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PerpetualCalendar entity = new PerpetualCalendar();
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("day")) {
      Object obj = map.get("day");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isSpecial")) {
      Object obj = map.get("isSpecial");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsSpecial((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isWorkday")) {
      Object obj = map.get("isWorkday");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsWorkday((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amBegin")) {
      Object obj = map.get("amBegin");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmBegin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amEnd")) {
      Object obj = map.get("amEnd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmEnd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmBegin")) {
      Object obj = map.get("pmBegin");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPmBegin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmEnd")) {
      Object obj = map.get("pmEnd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPmEnd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("runingHour")) {
      Object obj = map.get("runingHour");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRuningHour((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRuningHour(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRuningHour(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("weekday")) {
      Object obj = map.get("weekday");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWeekday((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("yearMonthDay")) {
      Object obj = map.get("yearMonthDay");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setYearMonthDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setYearMonthDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setYearMonthDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setYearMonthDay(null);
      }
    }
    if(map.containsKey("dataType")) {
      Object obj = map.get("dataType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMonth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("day")) {
      Object obj = map.get("day");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isSpecial")) {
      Object obj = map.get("isSpecial");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsSpecial((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isWorkday")) {
      Object obj = map.get("isWorkday");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsWorkday((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amBegin")) {
      Object obj = map.get("amBegin");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmBegin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amEnd")) {
      Object obj = map.get("amEnd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmEnd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pmBegin")) {
      Object obj = map.get("pmBegin");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPmBegin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pmEnd")) {
      Object obj = map.get("pmEnd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPmEnd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("runingHour")) {
      Object obj = map.get("runingHour");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRuningHour((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRuningHour(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRuningHour(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("weekday")) {
      Object obj = map.get("weekday");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWeekday((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("yearMonthDay")) {
      Object obj = map.get("yearMonthDay");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setYearMonthDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setYearMonthDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setYearMonthDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setYearMonthDay(null);
      }
    }
    if(map.containsKey("dataType")) {
      Object obj = map.get("dataType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataType((String)obj);
        }
      } else {
      }
    }
  }
}
