package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * company_role_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-15
 */
public enum CompanyRoleType {

    _0("0", "核心购销方公司申请"),
    _1("1", "客户公司申请"),
    _2("2", "供应商公司申请"),
    _3("3", "核心购方公司申请"),
    _4("4", "核心销方公司申请");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CompanyRoleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompanyRoleType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
