package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * legal_person_data_sources
 * </p>
 *
 * @author ultraman
 * @since 2024-01-15
 */
public enum LegalPersonDataSources {

    A("a", " 新增法人同步到发票平台，且协同标识为“协同”"),
    B("b", "法人主信息协同标识变更"),
    C("c", "自校验失败，发票平台没有入库"),
    D("d", "其他"),
    E("e", "一般纳税人变更为小规模纳税人"),
    F("f", " 新增法人同步到发票平台，协同标识为“非协同”");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LegalPersonDataSources(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LegalPersonDataSources fromCode(String code){
        switch(code) {
            case "a":
                return A;
            case "b":
                return B;
            case "c":
                return C;
            case "d":
                return D;
            case "e":
                return E;
            case "f":
                return F;
            default:
                return null;
        }
    }
}
