package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * order_invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-15
 */
public enum OrderInvoiceType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    JU("ju", "增值税普通发票（卷票）"),
    CT("ct", "通行费增值税电子普通发票"),
    V("v", "机动车统一销售发票"),
    SE("se", "增值税电子专用发票"),
    QS("qs", "电子发票(增值税专用发票)"),
    QC("qc", "电子发票(普通发票)"),
    SZ("sz", "纸质发票(增值税专用发票)"),
    CZ("cz", "纸质发票(普通发票)"),
    M("m", "混合类型"),
    O("o", "其他"),
    Z("z", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OrderInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderInvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ju":
                return JU;
            case "ct":
                return CT;
            case "v":
                return V;
            case "se":
                return SE;
            case "qs":
                return QS;
            case "qc":
                return QC;
            case "sz":
                return SZ;
            case "cz":
                return CZ;
            case "m":
                return M;
            case "o":
                return O;
            case "z":
                return Z;
            default:
                return null;
        }
    }
}
