package com.xforceplus.ultraman.app.jcvankepurchaser.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * receipt_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-15
 */
public enum ReceiptType {

    INV("inv", "发票收据"),
    VR("vr", "开票收据"),
    IR("ir", "内部收据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReceiptType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceiptType fromCode(String code){
        switch(code) {
            case "inv":
                return INV;
            case "vr":
                return VR;
            case "ir":
                return IR;
            default:
                return null;
        }
    }
}
