package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 作废申请标识
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum ApplyInvalidFlag {

    _0("0", "正常"),
    _1("1", "申请作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyInvalidFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyInvalidFlag fromCode(String code) {
        return Stream.of(ApplyInvalidFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
