package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 申请变更类型
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum ApplyModifyType {

    _0("0", "公司角色变更"),
    _1("1", "税号变更"),
    _2("2", "名称变更"),
    _3("3", "开票用户变更"),
    _4("4", "其他信息变更"),
    _9("9", "注销");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyModifyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyModifyType fromCode(String code) {
        return Stream.of(ApplyModifyType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
