package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 审批状态
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum AuditStatus {

    _1("1", "未审核"),
    _2("2", "审核中"),
    _3("3", "审核通过"),
    _4("4", "审核不通过");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuditStatus fromCode(String code) {
        return Stream.of(AuditStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
