package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 自校验状态
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum AutoCheckStatus {

    _0("0", "未校验"),
    _1("1", "校验通过"),
    _2("2", "校验不通过");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AutoCheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AutoCheckStatus fromCode(String code) {
        return Stream.of(AutoCheckStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
