package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据认证状态
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum BillAuthStatus {

    _2("2", "未勾选"),
    _4("4", "已勾选"),
    _5("5", "勾选异常"),
    _6("6", "抵扣异常"),
    _8("8", "已确认抵扣"),
    _9("9", "部分勾选"),
    _10("10", "部分抵扣"),
    _11("11", "未抵扣");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillAuthStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillAuthStatus fromCode(String code) {
        return Stream.of(BillAuthStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
