package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否可抵扣
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum CanDeduction {

    _0("0", "不可抵扣"),
    _1("1", "可抵扣");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CanDeduction(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CanDeduction fromCode(String code) {
        return Stream.of(CanDeduction.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
