package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 公司角色类型
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum CompanyRoleType {

    _0("0", "核心购销方公司申请"),
    _1("1", "客户公司申请"),
    _2("2", "供应商公司申请"),
    _3("3", "核心购方公司申请"),
    _4("4", "核心销方公司申请");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CompanyRoleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompanyRoleType fromCode(String code) {
        return Stream.of(CompanyRoleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
