package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 来源系统
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum DataFromSystem {

    _1("1", "pdc"),
    _2("2", "费控"),
    _3("3", "sap");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataFromSystem(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataFromSystem fromCode(String code) {
        return Stream.of(DataFromSystem.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
