package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 日期类型
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum DataType {

    _1("1", "年"),
    _2("2", "月"),
    _3("3", "日");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataType fromCode(String code) {
        return Stream.of(DataType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
