package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 一周中的某一天
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum DayOfWeek {

    _1("1", "周一"),
    _2("2", "周二"),
    _3("3", "周三"),
    _4("4", "周四"),
    _5("5", "周五"),
    _6("6", "周六"),
    _7("7", "周日"),
    _0("0", "无");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DayOfWeek(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DayOfWeek fromCode(String code) {
        return Stream.of(DayOfWeek.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
