package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否超期
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum IsOverDued {

    _1("1", "未超期"),
    _2("2", "即将超期"),
    _3("3", "超期");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsOverDued(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsOverDued fromCode(String code) {
        return Stream.of(IsOverDued.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
