package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否生成凭证
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum IsVoucherCreated {

    _0("0", "未生成"),
    _1("1", "已生成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsVoucherCreated(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsVoucherCreated fromCode(String code) {
        return Stream.of(IsVoucherCreated.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
