package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开具原因
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum MakingReason {

    SALES_RETURN("sales_return", "销货退回"),
    MAKING_ERROR("making_error", "开票有误"),
    TAXABLE_SERVICE_END("taxable_service_end", "应税服务终止"),
    SALES_ALLOWANCE("sales_allowance", "发生销售折让");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MakingReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MakingReason fromCode(String code) {
        return Stream.of(MakingReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
